#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;
struct tacka{
    int x=0, y=0;
    bool operator<(const tacka& other)const{
        if(x==other.x) return y<other.y;  
        return x<other.x; 
    }
};
long long vektorski(tacka C,tacka A,tacka B) {
    return (long long)(A.x-C.x)*(B.y-C.y)-(long long)(A.y-C.y)*(B.x-C.x);
}
long long pPoligona(vector<tacka> poligon) {
    long long p=0;
    int n=poligon.size();
    for(int i=0; i<n; i++){
        int j=(i+1)%n;
        p+=(long long)(poligon[i].x)*poligon[j].y-(long long)(poligon[j].x)*poligon[i].y;
    }
    return abs(p)/2;
}
vector<tacka> hullkonveksan(vector<tacka>& tacke) {
    sort(tacke.begin(), tacke.end());
    vector<tacka> hull;
    for(int i=0; i<tacke.size(); i++){
        while(hull.size()>=2 && vektorski(hull[hull.size()-2],hull[hull.size()-1],tacke[i])<=0){
        	hull.pop_back();
		} 
        hull.push_back(tacke[i]);
    }
    int t=hull.size()+1;
    for(int i=tacke.size()-1; i>-1; i--){
        while(hull.size()>=t && vektorski(hull[hull.size()-2],hull[hull.size()-1],tacke[i])<=0){
        	hull.pop_back();
		} 
        hull.push_back(tacke[i]);
    }
    hull.pop_back();
    return hull;
}
int main(){
    int n;
    cin>>n;
    vector<tacka> tacke(n);
    for(int i=0; i<n; i++){
        cin>>tacke[i].x>>tacke[i].y;
    }
    vector<tacka> hull=hullkonveksan(tacke);
    long long minp=pPoligona(hull);  
    vector<tacka> novetacke(n);
	for(int i=0; i<n; i++){
		novetacke[i]=tacke[i];
	}
 	tacka uklonjenatacka=novetacke[0];
 	int N=novetacke.size();
 	for(int i=0; i<N; i++){
        novetacke[i%N]=novetacke[(i+1)%N];
        vector<tacka> noviHull=hullkonveksan(novetacke);
        minp=min(minp,pPoligona(noviHull));
        novetacke[i%N]=uklonjenatacka;
        uklonjenatacka=novetacke[(i+1)%N];
    }
    cout<<minp;
    return 0;
}